/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;

public final class PdfPrintTransform {
    private boolean autoRotate;
    private final boolean chooseSourceByPDFSize;
    private int scalingMode;
    private double scalingFactor;
    private boolean centerOnScaling;
    private Rectangle crop;
    private PageFormat format;

    public PdfPrintTransform(boolean bl, boolean bl2, int n, boolean bl3) {
        this.autoRotate = bl;
        this.centerOnScaling = bl2;
        this.chooseSourceByPDFSize = bl3;
        this.setPageScaling(n);
        this.scalingFactor = 1.0;
    }

    public AffineTransform getPageTransform(int n, int n2, int n3, int n4, int n5, PageFormat pageFormat) {
        return this.getPageTransform(new Rectangle(n, n2, n3, n4), n5, pageFormat);
    }

    public void setAutoRotateAndCenter(boolean bl) {
        this.autoRotate = bl;
        this.centerOnScaling = bl;
    }

    public void setAutoRotateAndCenter(boolean bl, boolean bl2) {
        this.autoRotate = bl;
        this.centerOnScaling = bl2;
    }

    public void setPageScaling(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                this.scalingMode = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Scaling mode type: " + n);
            }
        }
    }

    public AffineTransform getPageTransform(Rectangle rectangle, int n, PageFormat pageFormat) {
        this.crop = rectangle;
        this.format = pageFormat;
        AffineTransform affineTransform = new AffineTransform();
        this.scalingFactor = 1.0;
        boolean bl = false;
        if (this.autoRotate || this.chooseSourceByPDFSize) {
            boolean bl2;
            boolean bl3 = pageFormat.getImageableWidth() > pageFormat.getImageableHeight();
            boolean bl4 = bl2 = this.crop.width > this.crop.height;
            if (n == 90 || n == 270) {
                bl2 = this.crop.width < this.crop.height;
            }
            boolean bl5 = bl = bl3 != bl2;
        }
        if (!bl) {
            if ((n += 180) > 360) {
                n -= 360;
            }
        } else if ((n += 90) > 360) {
            n -= 360;
        }
        double d = n % 180 == 0 ? (double)this.crop.width : (double)this.crop.height;
        double d2 = n % 180 == 0 ? (double)this.crop.height : (double)this.crop.width;
        double d3 = (pageFormat.getImageableWidth() - 1.0) / d;
        double d4 = (pageFormat.getImageableHeight() - 1.0) / d2;
        if ((d3 < 1.0 || d4 < 1.0) && this.scalingMode == 2 || this.scalingMode == 1) {
            double d5 = this.scalingFactor = d3 < d4 ? d3 : d4;
        }
        if (n != 0 || bl) {
            this.applyRotation(affineTransform, n);
        }
        if (this.crop.x != 0 || this.crop.y != 0) {
            this.applyCrop(affineTransform, n);
        }
        this.applyOffset(affineTransform, n);
        if (this.centerOnScaling) {
            this.applyCentering(affineTransform, n);
        }
        if (this.scalingMode != 0) {
            affineTransform.scale(this.scalingFactor, this.scalingFactor);
        }
        affineTransform.scale(-1.0, 1.0);
        affineTransform.translate(-this.crop.width, 0.0);
        this.crop = null;
        this.format = null;
        return affineTransform;
    }

    private void applyRotation(AffineTransform affineTransform, int n) {
        int n2 = n / 90;
        affineTransform.rotate((double)n2 * Math.PI / 2.0);
        switch (n2) {
            case 1: {
                affineTransform.translate(0.0, -((double)this.crop.height * this.scalingFactor));
                break;
            }
            case 2: {
                affineTransform.translate(-((double)this.crop.width * this.scalingFactor), -((double)this.crop.height * this.scalingFactor));
                break;
            }
            case 3: {
                affineTransform.translate(-((double)this.crop.width * this.scalingFactor), 0.0);
            }
        }
    }

    private void applyCrop(AffineTransform affineTransform, int n) {
        switch (n) {
            case 0: {
                affineTransform.translate((double)this.crop.x * this.scalingFactor, (double)(-this.crop.y) * this.scalingFactor);
                break;
            }
            case 90: {
                affineTransform.translate((double)this.crop.x * this.scalingFactor, (double)(-this.crop.y) * this.scalingFactor);
                break;
            }
            case 180: {
                affineTransform.translate((double)this.crop.x * this.scalingFactor, (double)(-this.crop.y) * this.scalingFactor);
                break;
            }
            case 270: {
                affineTransform.translate((double)this.crop.x * this.scalingFactor, (double)(-this.crop.y) * this.scalingFactor);
            }
        }
    }

    private void applyOffset(AffineTransform affineTransform, int n) {
        switch (n) {
            case 0: {
                affineTransform.translate(this.format.getImageableX(), this.format.getImageableY());
                break;
            }
            case 90: {
                affineTransform.translate(this.format.getImageableX(), -this.format.getImageableY());
                break;
            }
            case 180: {
                affineTransform.translate(-this.format.getImageableX(), -this.format.getImageableY());
                break;
            }
            case 270: {
                affineTransform.translate(-this.format.getImageableX(), this.format.getImageableY());
            }
        }
    }

    private void applyCentering(AffineTransform affineTransform, int n) {
        double d = 0.0;
        double d2 = 0.0;
        switch (n) {
            case 0: {
                d = (this.format.getImageableWidth() - (double)this.crop.width * this.scalingFactor) / 2.0;
                d2 = (this.format.getImageableHeight() - (double)this.crop.height * this.scalingFactor) / 2.0;
                break;
            }
            case 90: {
                d = (this.format.getImageableHeight() - (double)this.crop.width * this.scalingFactor) / 2.0;
                d2 = -((this.format.getImageableWidth() - (double)this.crop.height * this.scalingFactor) / 2.0);
                break;
            }
            case 180: {
                d = -(this.format.getImageableWidth() - (double)this.crop.width * this.scalingFactor) / 2.0;
                d2 = -(this.format.getImageableHeight() - (double)this.crop.height * this.scalingFactor) / 2.0;
                break;
            }
            case 270: {
                d = -(this.format.getImageableHeight() - (double)this.crop.width * this.scalingFactor) / 2.0;
                d2 = (this.format.getImageableWidth() - (double)this.crop.height * this.scalingFactor) / 2.0;
            }
        }
        affineTransform.translate(d, d2);
    }
}

