/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.preloader;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import net.babelsoft.negatron.preloader.Language;

public final class AlertBox
extends Dialog
implements ActionListener {
    private Button okButton;
    private Button cancelButton;
    public boolean isOk = false;

    AlertBox(Frame frame, String string, boolean bl) {
        super(frame, Language.Manager.getString("fatalError"), true);
        this.setLayout(new BorderLayout());
        this.add("Center", new Label(string));
        this.addOKCancelPanel(bl);
        this.createFrame();
        this.pack();
        this.setVisible(true);
    }

    AlertBox(Frame frame, String string) {
        this(frame, string, false);
    }

    void addOKCancelPanel(boolean bl) {
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout());
        this.createOkButton(panel);
        if (bl) {
            this.createCancelButton(panel);
        }
        this.add("South", panel);
    }

    void createOkButton(Panel panel) {
        this.okButton = new Button(Language.Manager.getString("ok"));
        panel.add(this.okButton);
        this.okButton.addActionListener(this);
    }

    void createCancelButton(Panel panel) {
        this.cancelButton = new Button(Language.Manager.getString("cancel"));
        panel.add(this.cancelButton);
        this.cancelButton.addActionListener(this);
    }

    void createFrame() {
        Dimension dimension = this.getToolkit().getScreenSize();
        this.setLocation(dimension.width / 3, dimension.height / 3);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            this.isOk = true;
            this.setVisible(false);
        } else if (actionEvent.getSource() == this.cancelButton) {
            this.setVisible(false);
        }
    }

    public static AlertBox showAndWait(String string) {
        return new AlertBox(null, string, false);
    }
}

