/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.preloader;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.application.Preloader;
import javafx.css.PseudoClass;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Control;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.StringConverter;
import net.babelsoft.negatron.preloader.AlertBox;
import net.babelsoft.negatron.preloader.Language;

public class NegatronPreloader
extends Preloader {
    private static final Path NEGATRON_INI = Paths.get("./Negatron.ini", new String[0]);
    private static final PseudoClass ERROR_CLASS = PseudoClass.getPseudoClass((String)"error");
    private static final String MAME = "MAME";
    private static final String MESS = "MESS";
    private Notifier notifier;
    private ProgressBar bar;
    private Label label;
    private Stage stage;
    private ResourceBundle language;
    private boolean isMess;

    public void start(Stage stage) throws Exception {
        this.stage = stage;
        if (Files.exists(NEGATRON_INI, new LinkOption[0])) {
            Files.lines(NEGATRON_INI).filter(string -> string.startsWith("language ")).findAny().ifPresent(string -> {
                String string2 = string.substring(9).trim();
                Locale.setDefault(Locale.forLanguageTag(string2));
            });
        }
        this.language = Language.Manager.getBundle();
        float f = Float.parseFloat(System.getProperty("java.specification.version"));
        String string2 = System.getProperty("javafx.version");
        if (f < 1.8f || string2 == null || string2.trim().equals("")) {
            AlertBox alertBox = AlertBox.showAndWait(String.format(this.language.getString("javaVersion.error"), Float.valueOf(f)));
            alertBox.dispose();
            throw new RuntimeException("You need to run Java 1.8+");
        }
        String[] stringArray = string2.split("\\.");
        int n = Integer.parseInt(stringArray[0]);
        if (n < 8 || n == 8 && stringArray.length > 1 && Integer.parseInt(stringArray[1]) == 0 && stringArray.length > 2 && Integer.parseInt(stringArray[2]) < 60) {
            AlertBox alertBox = AlertBox.showAndWait(String.format(this.language.getString("javaFxVersion.error"), string2));
            alertBox.dispose();
            throw new RuntimeException("You need to run Java 8.0.60+");
        }
        long l = Runtime.getRuntime().maxMemory() / 1024L / 1024L;
        if (0L < l && l <= 450L) {
            Alert alert = new Alert(Alert.AlertType.ERROR, String.format(this.language.getString("maxMemory.error"), l), new ButtonType[]{ButtonType.CLOSE});
            alert.showAndWait();
            throw new RuntimeException("You need to allow at least 512MB of memory to Negatron");
        }
        stage.setTitle(this.language.getString("welcome"));
        stage.getIcons().add((Object)new Image(NegatronPreloader.class.getResourceAsStream("resource/Negatron.16.png")));
        stage.getIcons().add((Object)new Image(NegatronPreloader.class.getResourceAsStream("resource/Negatron.32.png")));
        stage.getIcons().add((Object)new Image(NegatronPreloader.class.getResourceAsStream("resource/Negatron.64.png")));
        stage.setScene(this.createPreloaderScene());
        stage.show();
        if (Files.notExists(NEGATRON_INI, new LinkOption[0])) {
            this.label.setText(this.language.getString("configuring..."));
            Dialog<Configuration> dialog = this.createPromptDialog();
            dialog.initOwner((Window)stage);
            dialog.showAndWait().ifPresent(configuration -> {
                try (BufferedWriter bufferedWriter = Files.newBufferedWriter(NEGATRON_INI, new OpenOption[0]);){
                    String string = ((Configuration)configuration).mamePath;
                    if (string.contains(" ")) {
                        string = "\"" + string + "\"";
                    }
                    if (this.isMess) {
                        bufferedWriter.write("mess                      ");
                    } else {
                        bufferedWriter.write("mame                      ");
                    }
                    bufferedWriter.write(string);
                    bufferedWriter.newLine();
                    bufferedWriter.write("extras                    ");
                    bufferedWriter.write(((Configuration)configuration).extrasPath);
                    bufferedWriter.newLine();
                    bufferedWriter.write("multimedia                ");
                    bufferedWriter.write(((Configuration)configuration).multimediaPath);
                    bufferedWriter.newLine();
                    bufferedWriter.write("language                  ");
                    bufferedWriter.write(((Configuration)configuration).language);
                    bufferedWriter.newLine();
                }
                catch (IOException iOException) {
                    Logger.getLogger(NegatronPreloader.class.getName()).log(Level.SEVERE, "Couldn't write ini file", iOException);
                }
            });
        }
        this.label.setText(this.language.getString("loading..."));
    }

    private Scene createPreloaderScene() throws IOException {
        ImageView imageView = new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("resource/NegatronLogo.png")));
        this.bar = new ProgressBar();
        this.label = new Label();
        VBox vBox = new VBox();
        vBox.setAlignment(Pos.CENTER);
        vBox.setCenterShape(true);
        vBox.setSpacing(5.0);
        vBox.getChildren().add((Object)imageView);
        vBox.getChildren().add((Object)this.bar);
        vBox.getChildren().add((Object)this.label);
        Scene scene = new Scene((Parent)vBox, 300.0, 150.0);
        if (Files.exists(NEGATRON_INI, new LinkOption[0])) {
            Files.lines(NEGATRON_INI).filter(string -> string.startsWith("skin ")).findAny().ifPresent(string -> {
                Path path;
                String string2 = string.substring(5).trim();
                if (string2.length() != 0 && Files.exists(path = Paths.get("theme/skin/" + string2 + "/skin.css", new String[0]), new LinkOption[0])) {
                    scene.getStylesheets().setAll((Object[])new String[]{path.toUri().toString()});
                }
            });
        }
        return scene;
    }

    private Dialog<Configuration> createPromptDialog() {
        Dialog dialog = new Dialog();
        dialog.setTitle(this.language.getString("configuration"));
        dialog.setHeaderText(this.language.getString("configuration.text"));
        dialog.setGraphic((Node)new ImageView(((Object)((Object)this)).getClass().getResource("resource/MAME.png").toExternalForm()));
        dialog.getDialogPane().getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("PromptDialog.css").toExternalForm());
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        GridPane gridPane = new GridPane();
        gridPane.setHgap(10.0);
        gridPane.setVgap(10.0);
        gridPane.setPadding(new Insets(20.0, 10.0, 10.0, 10.0));
        gridPane.setMinWidth(500.0);
        Label label = new Label(MAME);
        TextField textField = new TextField();
        Button button = new Button(this.language.getString("browse..."));
        Label label2 = new Label("MAME EXTRAs");
        TextField textField2 = new TextField();
        Button button2 = new Button(this.language.getString("browse..."));
        Label label3 = new Label("MAME Multimedia");
        TextField textField3 = new TextField();
        Button button3 = new Button(this.language.getString("browse..."));
        Label label4 = new Label(this.language.getString("language"));
        final ChoiceBox choiceBox = new ChoiceBox();
        textField.setPromptText(this.language.getString("mame.prompt"));
        textField.pseudoClassStateChanged(ERROR_CLASS, true);
        textField.textProperty().addListener((observableValue, string, string2) -> {
            if (string2 == null || string2.trim().isEmpty()) {
                textField.pseudoClassStateChanged(ERROR_CLASS, true);
            } else {
                textField.pseudoClassStateChanged(ERROR_CLASS, false);
            }
        });
        button.setOnAction(actionEvent -> {
            Control control = (Control)actionEvent.getSource();
            FileChooser fileChooser = new FileChooser();
            fileChooser.setInitialDirectory(new File("."));
            if (System.getProperty("os.name").toLowerCase().contains("win")) {
                fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter(MAME, new String[]{"*mame*.exe"}), new FileChooser.ExtensionFilter(MESS, new String[]{"*mess*.exe"})});
            } else {
                fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter(MAME, new String[]{"*mame*"}), new FileChooser.ExtensionFilter(MESS, new String[]{"*mess*"})});
            }
            fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(this.language.getString("allFiles"), new String[]{"*"}));
            File file = fileChooser.showOpenDialog(control.getScene().getWindow());
            if (file != null) {
                if (file.getName().contains("mess")) {
                    dialog.setHeaderText(dialog.getHeaderText().replace(MAME, MESS));
                    dialog.setGraphic((Node)new ImageView(((Object)((Object)this)).getClass().getResource("resource/MESS.png").toExternalForm()));
                    label.setText(MESS);
                    textField.setPromptText(textField.getPromptText().replace(MAME, MESS));
                    label2.setText("MESS EXTRAs");
                    textField2.setPromptText(textField2.getPromptText().replace(MAME, MESS));
                    label3.setVisible(false);
                    textField3.setVisible(false);
                    button3.setVisible(false);
                    this.isMess = true;
                } else {
                    dialog.setHeaderText(dialog.getHeaderText().replace(MESS, MAME));
                    dialog.setGraphic((Node)new ImageView(((Object)((Object)this)).getClass().getResource("resource/MAME.png").toExternalForm()));
                    label.setText(MAME);
                    textField.setPromptText(textField.getPromptText().replace(MESS, MAME));
                    label2.setText("MAME EXTRAs");
                    textField2.setPromptText(textField2.getPromptText().replace(MESS, MAME));
                    label3.setVisible(true);
                    textField3.setVisible(true);
                    button3.setVisible(true);
                    this.isMess = false;
                }
                textField.setText(file.getAbsolutePath());
            }
        });
        textField2.setPromptText(this.language.getString("extras.prompt"));
        button2.setOnAction(actionEvent -> {
            Control control = (Control)actionEvent.getSource();
            DirectoryChooser directoryChooser = new DirectoryChooser();
            if (this.isMess) {
                directoryChooser.setTitle("MESS EXTRAs");
            } else {
                directoryChooser.setTitle("MAME EXTRAs");
            }
            if (!textField.getText().trim().isEmpty()) {
                directoryChooser.setInitialDirectory(Paths.get(textField.getText().trim(), new String[0]).getParent().toFile());
            } else {
                directoryChooser.setInitialDirectory(new File("."));
            }
            File file = directoryChooser.showDialog(control.getScene().getWindow());
            if (file != null) {
                textField2.setText(file.getAbsolutePath());
            }
        });
        textField3.setPromptText(this.language.getString("multimedia.prompt"));
        button3.setOnAction(actionEvent -> {
            Control control = (Control)actionEvent.getSource();
            DirectoryChooser directoryChooser = new DirectoryChooser();
            directoryChooser.setTitle("MAME Multimedia");
            if (!textField2.getText().trim().isEmpty()) {
                directoryChooser.setInitialDirectory(Paths.get(textField2.getText().trim(), new String[0]).getParent().toFile());
            } else if (!textField.getText().trim().isEmpty()) {
                directoryChooser.setInitialDirectory(Paths.get(textField.getText().trim(), new String[0]).getParent().toFile());
            } else {
                directoryChooser.setInitialDirectory(new File("."));
            }
            File file = directoryChooser.showDialog(control.getScene().getWindow());
            if (file != null) {
                textField3.setText(file.getAbsolutePath());
            }
        });
        choiceBox.getItems().add((Object)Locale.UK);
        Path path = Paths.get(Language.Manager.ROOT_PATH, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            try {
                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                        int n;
                        String string = path.getFileName().toString();
                        if (string.matches(Language.Manager.MASK) && (n = string.indexOf(95)) >= 0) {
                            String string2 = string.substring(n + 1, string.length() - 11).replace('_', '-');
                            choiceBox.getItems().add((Object)Locale.forLanguageTag(string2));
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
                        if (iOException == null) {
                            return FileVisitResult.CONTINUE;
                        }
                        throw iOException;
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        choiceBox.setConverter((StringConverter)new StringConverter<Locale>(){

            public String toString(Locale locale) {
                return locale.getDisplayName(locale);
            }

            public Locale fromString(String string) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        });
        Locale locale3 = Locale.getDefault();
        if (choiceBox.getItems().contains((Object)locale3)) {
            choiceBox.getSelectionModel().select((Object)locale3);
        } else {
            choiceBox.getSelectionModel().select((Object)Locale.UK);
        }
        choiceBox.getSelectionModel().selectedItemProperty().addListener((observableValue, locale, locale2) -> {
            Locale.setDefault(locale2);
            this.language = Language.Manager.getBundle();
            this.stage.setTitle(this.language.getString("welcome"));
            this.label.setText(this.language.getString("configuring..."));
            dialog.setTitle(this.language.getString("configuration"));
            dialog.setHeaderText(this.language.getString("configuration.text"));
            textField.setPromptText(this.language.getString("mame.prompt"));
            button.setText(this.language.getString("browse..."));
            textField2.setPromptText(this.language.getString("extras.prompt"));
            button2.setText(this.language.getString("browse..."));
            textField3.setPromptText(this.language.getString("multimedia.prompt"));
            button3.setText(this.language.getString("browse..."));
            label4.setText(this.language.getString("language"));
        });
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setHgrow(Priority.SOMETIMES);
        gridPane.getColumnConstraints().add((Object)new ColumnConstraints());
        gridPane.getColumnConstraints().add((Object)columnConstraints);
        gridPane.add((Node)label, 0, 0);
        gridPane.add((Node)textField, 1, 0);
        gridPane.add((Node)button, 2, 0);
        gridPane.add((Node)label2, 0, 1);
        gridPane.add((Node)textField2, 1, 1);
        gridPane.add((Node)button2, 2, 1);
        gridPane.add((Node)label3, 0, 2);
        gridPane.add((Node)textField3, 1, 2);
        gridPane.add((Node)button3, 2, 2);
        gridPane.add((Node)label4, 0, 3);
        gridPane.add((Node)choiceBox, 1, 3, 2, 1);
        Node node = dialog.getDialogPane().lookupButton(ButtonType.OK);
        node.setDisable(true);
        textField.textProperty().addListener((observableValue, string, string2) -> node.setDisable(string2 == null || string2.trim().isEmpty()));
        dialog.getDialogPane().setContent((Node)gridPane);
        Platform.runLater(() -> textField.requestFocus());
        dialog.setResultConverter(buttonType -> {
            if (buttonType == ButtonType.OK) {
                return new Configuration(textField.getText(), textField2.getText(), textField3.getText(), ((Locale)choiceBox.getSelectionModel().getSelectedItem()).toLanguageTag());
            }
            return null;
        });
        if (!System.getProperty("os.name").toLowerCase().contains("win")) {
            ProcessBuilder processBuilder = new ProcessBuilder("which", "mame");
            try (InputStream inputStream = processBuilder.start().getInputStream();
                 InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                 BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                textField.setText(bufferedReader.readLine());
            }
            catch (IOException iOException) {
                Logger.getLogger(NegatronPreloader.class.getName()).log(Level.SEVERE, null, iOException);
            }
        }
        return dialog;
    }

    public void handleStateChangeNotification(Preloader.StateChangeNotification stateChangeNotification) {
        if (stateChangeNotification.getType() == Preloader.StateChangeNotification.Type.BEFORE_INIT) {
            this.notifier = (Notifier)stateChangeNotification.getApplication();
            this.notifier.onConfigurationSucceeded();
        }
    }

    public void handleApplicationNotification(Preloader.PreloaderNotification preloaderNotification) {
        if (preloaderNotification instanceof Preloader.ProgressNotification) {
            double d = ((Preloader.ProgressNotification)preloaderNotification).getProgress();
            if (d < 0.99) {
                this.bar.setProgress(d);
                this.label.setText(this.language.getString("processingMameInput...").replace(MAME, this.isMess ? MESS : MAME));
            } else {
                this.bar.setProgress(-1.0);
                this.label.setText(this.language.getString("formattingData..."));
            }
        } else if (preloaderNotification instanceof Preloader.StateChangeNotification) {
            this.stage.hide();
            this.notifier.onPreloadingSucceeded();
        } else if (preloaderNotification instanceof Preloader.ErrorNotification) {
            Preloader.ErrorNotification errorNotification = (Preloader.ErrorNotification)preloaderNotification;
            Alert alert = new Alert(Alert.AlertType.ERROR, errorNotification.getLocation() + ":\n\n" + errorNotification.getCause().toString() + "\n\n" + errorNotification.getDetails(), new ButtonType[]{ButtonType.CLOSE});
            alert.initOwner((Window)this.stage);
            alert.showAndWait();
            this.stage.close();
        }
    }

    public static interface Notifier {
        public void onConfigurationSucceeded();

        public void onPreloadingSucceeded();
    }

    private static class Configuration {
        private final String mamePath;
        private final String extrasPath;
        private final String multimediaPath;
        private final String language;

        private Configuration(String string, String string2, String string3, String string4) {
            this.mamePath = string;
            this.extrasPath = string2;
            this.multimediaPath = string3;
            this.language = string4;
        }
    }
}

